package com.bizvane.members.facade.service.card.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 开卡请求类
 */

@Data
@EqualsAndHashCode
public class RequestOpenCardModel {

    //必填字段
    @ApiModelProperty(name = "appId", value = "appId")
    private String appId;

    @ApiModelProperty(name = "unionId", value = "unionId")
    private String unionId;

    @ApiModelProperty(name = "openId", value = "openId")
    private String openId;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    //选填字段
    @ApiModelProperty(name = "name", value = "姓名")
    private String name;

    @ApiModelProperty(name = "openStoreCode", value = "开卡门店code")
    private String openStoreCode;

    @ApiModelProperty(name = "openGuideCode", value = "开卡导购code")
    private String openGuideCode;

    @ApiModelProperty(name = "birthday", value = "生日")
    private Date birthday;

    @ApiModelProperty(value = "会员邮件", name = "email")
    private String email;

    @ApiModelProperty(name = "gender", value = "性别")
    private Integer gender;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "city", value = "城市")
    private String city;

    @ApiModelProperty(name = "county", value = "区县")
    private String county;

    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;

    @ApiModelProperty(name = "isExist", value = "是否存在")
    private Boolean isExist = false;


    @ApiModelProperty(name = "activetyId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "activityType", value = "活动类型")
    private Integer activityType;

    @ApiModelProperty(name = "recommendMemberCode", value = "推荐人memberCode")
    private String recommendMemberCode;


    //以下为电子会员卡特有字段
    @ApiModelProperty(name = "electCardSource", value = "开卡来源渠道是否电子会员卡")
    private Boolean electCardSource;

    @ApiModelProperty(name = "sysBrandId", value = "企业品牌id")
    private Long sysBrandId;

    @ApiModelProperty(name = "defaultLevelId", value = "默认电子会员卡等级id")
    private Long defaultLevelId;
}
