package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 自动标签vo 新增/编辑
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月03日 15:27:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AutoLabelReqVo implements Serializable {

    /**
     * 自动标签分组id
     */
    @ApiModelProperty(value = "自动标签分组id", name = "autoLabelGroupId")
    @NotNull
    private Long autoLabelGroupId;

    /**
     * 自动标签名称
     */
    @ApiModelProperty(value = "自动标签名称", name = "name")
    @NotEmpty
    private String name;

    /**
     * 自动标签描述
     */
    @ApiModelProperty(value = "自动标签描述", name = "desc")
    private String description;

    /**
     * 自动标签更新周期
     */
    @ApiModelProperty(value = "自动标签更新周期", name = "cycleType")
    private Integer cycleType;

    /**
     * 上下架状态字段
     */
    @ApiModelProperty(value = "上下架状态字段", name = "putAwayStatus")
    private Integer putAwayStatus;

    /**
     * 自动标签条件
     */
    @ApiModelProperty(value = "自动标签会员圈定条件 跟会员高级搜索传参一样 lastBuyTimeRange consumeAmount consumeNumber", name = "labelCondition")
    private MembersInfoSearchVo labelCondition;

    /**
     * 自动标签id
     */
    @ApiModelProperty(value = "自动标签id 更新接口必传", name = "autoLabelId")
    private Long autoLabelId;

    /**
     * 页数
     */
    @ApiModelProperty(value = "页数", name = "pageNum")
    private Integer pageNum;

    /**
     * 每页数量
     */
    @ApiModelProperty(value = "每页数量", name = "pageSize")
    private Integer pageSize;

}
