package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.vo.BatchUpdateMemberInfoVo;
import com.bizvane.members.facade.vo.MemberCardInfoRes;
import com.bizvane.members.facade.vo.MemberLabelInfoRes;
import com.bizvane.members.facade.vo.OrderApiVo;
import com.bizvane.members.facade.vo.qywx.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/11/5 14:22
 * @Description:
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CompanyMemberApiService {
    /**
     * 会员详情查询
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/companyMember/queryMemberCardInfo", method = RequestMethod.POST)
    ResponseData<MemberCardInfoRes> queryMemberCardInfo(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 查询会员订单列表
     *
     * @param orderApiVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/companyMember/queryOrderList", method = RequestMethod.POST)
    ResponseData<PageInfo<OrderModel>> queryOrderList(@RequestBody OrderApiVo orderApiVo) throws MemberException;

    /**
     * 设置会员备注
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/companyMember/updateMemberComment", method = RequestMethod.POST)
    ResponseData updateMemberComment(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 根据品牌id和unionid查询会员信息
     *
     * @param memberInfoModel
     * @return
     */
    @RequestMapping(value = "/api/companyMember/queryMemberByUnionId", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> queryMemberByUnionId(@RequestBody MemberInfoModel memberInfoModel);

    /**
     * 批量修改会员服务导购
     *
     * @param batchUpdateMemberInfoVo
     * @return
     */
    @RequestMapping(value = "/api/companyMember/batchUpdateServiceGuide", method = RequestMethod.POST)
    ResponseData batchUpdateServiceGuide(@RequestBody BatchUpdateMemberInfoVo batchUpdateMemberInfoVo);

    /**
     * 根据导购id和品牌id移除服务导购所属会员
     *
     * 作废
     * @param memberInfoModel
     * @return
     */
    @RequestMapping(value = "/api/companyMember/removeServiceGuide", method = RequestMethod.POST)
    ResponseData removeServiceGuide(@RequestBody MemberInfoModel memberInfoModel);


    /**
     * 导购离职 异步
     *
     * @return
     */
    @RequestMapping(value = "/api/companyMember/staffHandle", method = RequestMethod.POST)
    ResponseData<String> staffHandle(@RequestBody @Valid StaffHandleVo staffHandleVo);

    /**
     * 查询导购下的会员数量
     *
     * @param brandId
     * @param serviceGuideId
     * @return
     */
    @RequestMapping(value = "/api/queryMemberCountByServiceGuide", method = RequestMethod.POST)
    ResponseData<Integer> queryMemberCountByServiceGuide(@RequestParam(value = "brandId") Long brandId, @RequestParam(value = "serviceGuideId") Long serviceGuideId);


    @RequestMapping(value = "/api/queryMemberBalanceByMemberCode", method = RequestMethod.POST)
    ResponseData<BigDecimal> queryMemberBalanceByMemberCode(@RequestParam(value = "memberCode") String memberCode);


    /**
     * 查询会员累计消费行为
     *
     * @param memberConsumeBehaviorRequestVo
     * @return
     */
    @RequestMapping(value = "/api/queryMemberConsumeBehaviorList", method = RequestMethod.POST)
    ResponseData<List<MemberConsumeBehaviorResponseVo>> queryMemberConsumeBehaviorList(@RequestBody @Valid MemberConsumeBehaviorRequestVo memberConsumeBehaviorRequestVo);


    @RequestMapping(value = "/api/queryAssignedMember", method = RequestMethod.POST)
    ResponseData<AssignedMemberInfo> queryAssignedMember(@RequestParam(value = "sysCompanyId") Long sysCompanyId, @RequestParam(value = "brandId") Long brandId, @RequestParam(value = "memberCode") String memberCode);

    @RequestMapping(value = "/api/queryMemberSysDef", method = RequestMethod.POST)
    ResponseData<MemberSysDefVo> queryMemberSysDef(@RequestParam(value = "sysCompanyId") Long sysCompanyId, @RequestParam(value = "brandId") Long brandId);


    @RequestMapping(value = "/api/queryNoElectricMembers",method = RequestMethod.POST)
    ResponseData<NoElectricMembersResponseVo> queryNoElectricMembers(@RequestBody @Valid DataLookUpRequestVo dataLookUpRequestVo);

    @RequestMapping(value = "/api/queryDevelopeMembers",method = RequestMethod.POST)
    ResponseData<PageInfo<DataLookUpResponseVo>> queryDevelopeMembers(@RequestBody @Valid DataLookUpRequestVo dataLookUpRequestVo);

    @RequestMapping(value = "/api/queryDevelopeChannel",method = RequestMethod.POST)
    ResponseData<PageInfo<DataLookUpResponseVo>> queryDevelopeChannel(@RequestBody @Valid DataLookUpRequestVo dataLookUpRequestVo);

    @RequestMapping(value = "/api/queryDevelopeFriends",method = RequestMethod.POST)
    ResponseData<PageInfo<DataLookUpResponseVo>> queryDevelopeFriends(@RequestBody @Valid DataLookUpRequestVo dataLookUpRequestVo);

    /**
     * 会员标签信息查询
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/companyMember/queryMemberLabelInfo", method = RequestMethod.POST)
    ResponseData<MemberLabelInfoRes> queryMemberLabelInfo(@RequestBody MemberLabelInfoRequestVo memberInfoModel) throws MemberException;

}
