package com.bizvane.members.facade.vo.vg;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BrandMessagesVO {
    //品牌名
    private String brandName;
    //等级
    private String levelName;
    //导购名
    private String guideName;
    //所属店铺名称
    private String storeName;

    private Date createDate;

    //店铺code
    private String storeCode;

    private String erpId;

    //关注时间
    private Date focusTime;
    @ApiModelProperty(value = "是否关注：1未关注，2已关注", name = "memberName")
    private Integer focus;

    @ApiModelProperty(value = "取关时间", name = "unFocusTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date unFocusTime;

    //公众号名称
    private String nickName;

    private Long brandId;

    @ApiModelProperty(value="是否是企微好友",name="companyFriend")
    private Boolean companyFriend;

    private Date openCardTime;

    //点亮俱乐部操作来源的 推广内容名称
    private String contentName;

    //点亮俱乐部操作来源的 内容类型 1.微信会员中心小程序 2.微信公众号 3.外部系统功能
    private Integer contentType;

    //点亮俱乐部操作来源的 推广渠道名称
    private String channelName;

    //点亮俱乐部操作来源的 推广来源名称
    private String sourceName;

    //点亮俱乐部操作来源的 来源编号
    private String sourceCode;

    //渠道Id 字符串类型
    private String channelId;

    //关联门店/导购编号
    private String sourceBusinessCode;

    //动作/事件类型：1.浏览，2.注册，3绑定，4点亮俱乐部
    private Integer actionType;

    //点亮俱乐部操作来源的 创建时间
    private Date sourceCreateDate;
}
