package com.bizvane.members.facade.enums;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum OrderTypeEnum {
    /**
     * es 查询排序类型
     */
    ORDER_BY_CONSUME(1, "按消费排序", "consumeAmount3"),
    /**
     * es 查询排序类型
     */
    ORDER_BY_INTEGRAL(2,"按积分排序", "countIntegral"),
    /**
     * es 查询排序类型
     */
    ORDER_BY_MEMBER_LEVEL(3,"按等级排序", "levelId");
    private Integer code;

    private String msg;

    private String esSortField;

    OrderTypeEnum(Integer code, String msg, String esSortField) {
        this.code = code;
        this.msg = msg;
        this.esSortField = esSortField;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getEsSortField() {
        return esSortField;
    }

    public void setEsSortField(String esSortField) {
        this.esSortField = esSortField;
    }

    public static OrderTypeEnum formByCodeOfDefault(Integer sortCode, OrderTypeEnum defaultOrderType) {
        return Arrays.stream(OrderTypeEnum.values())
                .filter(p->p.getCode().equals(sortCode)).findFirst().orElse(defaultOrderType);
    }
}
