package com.bizvane.members.facade.service.inner;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.members.facade.models.MbrRelationVo;
import com.bizvane.members.facade.models.po.MbrRelationTaskDetailPo;
import com.bizvane.members.facade.models.po.MbrRelationTaskPo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

/**
 * @Author: shifeng
 * @Date: 2022-10-8 16:56:02
 * @Description: 会员服务业务接口
 */
public interface MemberRelationService {

    /**
     * 导入变更excel解析接口
     * @param mbrRelationVo
     * 2022年10月9日18:36:04
     */
    ResponseData<Boolean> addMemberRelationTask(MbrRelationVo mbrRelationVo);

    /**
     * 更新会员绑定关系状态
     * @param mbrRelationVo
     * 2022年10月9日18:36:04
     */
    ResponseData<Boolean> updateMemberRelationTask(MbrRelationVo mbrRelationVo);

    /**
     * 导入会员关系excel中的数据
     * @param  mbrRelationVo
     * @return
     * 2022-10-17 12:13:46
     */
    ResponseData importMemberRelationExcel(MbrRelationVo mbrRelationVo);

    /**
     * 查询任务列表接口
     * @param mbrRelationVo
     * @return ResponseData
     * 2022-10-9 17:45:06
     */
    ResponseData<PageInfo<MbrRelationTaskPo>> queryRelationList(MbrRelationVo mbrRelationVo);

    /**
     * 查询任务详细信息
     * @param mbrRelationVo
     * @return
     * 2022-10-9 18:03:34
     */
    MbrRelationTaskPo queryRelationTaskDetail(MbrRelationVo mbrRelationVo);

    /**
     * 查询任务的会员处理明细列表信息
     * @param mbrRelationVo
     * @return
     * 2022-10-9 17:53:29
     */
    ResponseData<PageInfo<MbrRelationTaskDetailPo>> queryRelationDetailList(MbrRelationVo mbrRelationVo);

    /**
     * 导出会员关系功能
     * @param mbrRelationVo
     * @return
     * 2022-10-9 18:08:094
     */
    ResponseData<Object> exportRelationDetailList(MbrRelationVo mbrRelationVo, SysAccountPO accountPo);

    /**
     * 重新执行存在失败数据的任务
     * @param mbrRelationVo
     */
    ResponseData reStartDealing(MbrRelationVo mbrRelationVo);

}
