package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * base model
 */
@Data
@NoArgsConstructor
public class BaseModel implements Serializable {

    private static final long serialVersionUID = -1403277873418166981L;

    @ApiModelProperty(value = "数据有效性：1=有效；0=无效", name = "valid")
    private Integer valid;

    @ApiModelProperty(value = "说明/备注", name = "remark")
    private String remark;

    @ApiModelProperty(value = "创建人id", name = "createUserId")
    private Long createUserId;

    @ApiModelProperty(value = "创建用户名称", name = "createUserName")
    private String createUserName;

    @ApiModelProperty(value = "创建时间", name = "createDate")
    private Date createDate;

    @ApiModelProperty(value = "修改人id", name = "modifiedUserId")
    private Long modifiedUserId;

    @ApiModelProperty(value = "修改人用户名称", name = "modifiedUserName")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间", name = "modifiedDate")
    private Date modifiedDate;

    @ApiModelProperty(value = "版本号", name = "version")
    private Integer version;
    @ApiModelProperty(value = "排序字段",name = "sort")
    private Long sort;
}
