package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.ur.vo.UrOrderPayMentRespVo;
import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/24 16:23
 * @Description:
 */
@Data
public class OrderVo{

    private Long mbrOrderId;

    private String orderNo;

    private BigDecimal tradeAmount;

    private BigDecimal commodityAmount;

    private String discount;

    private Date placeOrderTime;

    private String serviceStoreName;

    private Integer getedIntegral;

    private String serviceGuideNames;

    private String guideNames;

    private Integer commodityNum;

    private Long sysCompanyId;

    private Date billTime;

    private String serviceStoreCode;

    private Long brandId;

    private Date payTime;

    //361经销商
    private String corpName;

    //361渠道
    private String channelName;


    @OneToMany(mappedBy = "t_mbr_order", cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @JoinColumn(name = "orderNo")
    @Transient
    private List<OrderDetailVo> details;

    @OneToMany(mappedBy = "t_mbr_order", cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @JoinColumn(name = "orderNo")
    @Transient
    private List<OrderPaymentVo> payments;
}
