package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.IntegralRecordModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/16.
 */
@Data
public class IntegralRecordVo extends IntegralRecordModel {

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间", name = "startTime")
    private Date startTime;

    private String startTimeStr;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间", name = "endTime")
    private Date endTime;

    private String endTimeStr;

    @ApiModelProperty(value = "会员卡等级名称", name = "levelName")
    private String levelName;

    @ApiModelProperty(value = "流水年份", name = "year")
    private String year;

    @ApiModelProperty(value = "当前页", name = "pageNum")
    private int pageNum;

    @ApiModelProperty(value = "每页记录数", name = "pageNum")
    private int pageSize;

    @ApiModelProperty(value = "业务类型", name = "businessIds")
    private String[] businessIds;

    ArrayList code;
}
