package com.bizvane.members.facade.service.card.request;

import com.bizvane.members.facade.enums.BasePropertyEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/18.
 */
@Data
@EqualsAndHashCode
public class PerfectMemberDataRequestModel {

        //===============可选修改条件=====================
        //memberCode
        @ApiModelProperty(name = "memberCode", value = "会员code")
        private String memberCode;

        //unionId或者unionId和openId的组合
        @ApiModelProperty(name = "unionId", value = "unionId")
        private String unionId;

        @ApiModelProperty(name = "openId", value = "openId")
        private String openId;

        //品牌和手机号的组合
        @ApiModelProperty(name = "brandId", value = "品牌id")
        private Long brandId;

        @ApiModelProperty(name = "phone", value = "手机号")
        private String phone;
        
        @ApiModelProperty(name="erpId",value="erpId")
        private String erpId;
        
        //==========可选修改字段================
        @ApiModelProperty(name = "cardNo", value = "线上卡号")
        private String cardNo;

        @ApiModelProperty(name = "offlineCardNo", value = "线下卡号")
        private String offlineCardNo;

        @ApiModelProperty(name = "name", value = "姓名")
        private String name;

        @ApiModelProperty(name = "gender", value = "性别")
        private String gender;

        @ApiModelProperty(name = "headPortraits",value = "会员头像")
        private String headPortraits;

        @ApiModelProperty(name = "email", value = "邮箱")
        private String email;

        @ApiModelProperty(name = "idCard", value = "身份证")
        private String idCard;

        @ApiModelProperty(name = "birthday", value = "生日")
        private Date birthday;

        @ApiModelProperty(name = "birthdayMd", value = "生日月日")
        private String birthdayMd;

        @ApiModelProperty(name = "province", value = "省")
        private String province;

        @ApiModelProperty(name = "city", value = "市")
        private String city;

        @ApiModelProperty(name = "county", value = "区县")
        private String county;

        @ApiModelProperty(name = "address", value = "详细地址")
        private String address;

        @ApiModelProperty(name = "remark", value = "备注")
        private String remark;



        //ID
        @ApiModelProperty(name = "levelId", value = "等级id")
        private Long levelId;

        @ApiModelProperty(name = "openStoreId", value = "开卡门店id")
        private String openStoreId;

        @ApiModelProperty(name = "openGuideId", value = "开卡导购id")
        private String openGuideId;

        @ApiModelProperty(name = "serviceStoreId", value = "服务门店id")
        private String serviceStoreId;

        @ApiModelProperty(name = "serviceGuideId", value = "服务导购id")
        private String serviceGuideId;


        //CODE
        @ApiModelProperty(name = "levelCode", value = "等级code")
        private String levelCode;

        @ApiModelProperty(name = "openStoreCode", value = "开卡门店编号")
        private String openStoreCode;

        @ApiModelProperty(name = "openGuideCode", value = "开卡导购编号")
        private String openGuideCode;

        @ApiModelProperty(name = "serviceStoreCode", value = "服务门店code")
        private String serviceStoreCode;

        @ApiModelProperty(name = "serviceGuide", value = "服务导购code")
        private String serviceGuideCode;


        //请求响应标记
        @ApiModelProperty(name = "memberUUID", value = "会员业务单号")
        private String memberUUID;

        private BasePropertyEnum basePropertyEnum;

        @ApiModelProperty(name = "areaCode",value = "手机号区号")
        private String areaCode;

        @ApiModelProperty(name = "yzOpenId",value = "有赞openId")
        private String yzOpenId;
}
