package com.bizvane.members.facade.ur.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

import java.util.Date;


@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UrRechargeConsumeRecordDetailResVo {

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "下单时间")
    private Date placeOrderTime;

    @ApiModelProperty(value = "订单详情")
    private List<UrOrderDetailResponseVo> productDetail;

    @ApiModelProperty(value = "支付详情")
    private List<UrOrderPayMentRespVo> urOrderPayMentResponseVoList;

    @ApiModelProperty(value = "订单支付金额")
    private BigDecimal orderPayMoney;

    @ApiModelProperty(value = "正单 or 退单")
    private Boolean Chargeback;
}
