package com.bizvane.members.facade.vo.third;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 第三方会员开卡请求vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月28日 10:06:00
 */
@Data
public class ThirdMemberOpenCardReqVo {

    private Long sysCompanyId;//公司id

    private String offlineCompanyCode;

    @NotEmpty
    private String brandCode;//	是	string	品牌
    @NotEmpty
    private String phone;//	是	string	手机号

    private String cardNo;//	是	string	会员卡号
    private String name;    //否	string	会员名称
    private Integer sex;    //否	int	性别 : 1.女 2.男 3.未知
    private String province;//	否	string	省
    private String city;//	否	string	市
    private String county;//	否	string	区
    private String address;//	否	string	会员详细地址
    private String remark;//	否	string	备注
    private String email;//	否	string	会员邮箱
    private String idCard;//	否	string	会员身份证号
    private String birthday;//	否	string	会员生日 格式 : yyyy-mm-dd
    private String storeCode;//	否	string	注册门店code,如果为空则默认按照中台配置的会员卡体系为准
    private String levelCode;//	否	string	会员等级code,如果为空则默认按照中台配置的会员卡体系为准

    //guideCode
    private String guideCode;//否 string 导购code,如果为空则默认按照中台配置的会员卡体系为准

    @NotNull
    private Integer source;//	是	int	会员注册渠道 : 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
    private Integer points;//	否	int	会员可用积分,如果为空则默认为0
    private String unionId;//	否	string	微信unionId
    private Integer valid;//	否	int	会员卡状态 : 0.禁用 1.可用,默认为1
//    private String erpId;// 否 string erpId
    private Date openCardTime;


    /**
     * 有赞等级名称
     */
    private String yzLevelName;
    
    
}
