package com.bizvane.members.facade.enums;

public enum GrowthBusinessTypeEnum {

    ADJUST_MANUAL(0, "手动调整"),
    ORDER_PRICE_GROWTH(1, "订单金额增加"),
    ORDER_NUM_GROWTH(2, "订单次数增加"),
    ORDER_REFUND_PRICE_GROWTH(3, "退单金额扣减"),
    ORDER_REFUND_NUM_GROWTH(4, "退单次数扣减"),
    LAST_30_NOT_CONSUME_GROWTH(5, "最近30未消费扣减"),
    LAST_90_NOT_CONSUME_GROWTH(6, "最近90天未消费扣减"),

    OPEN_CARD_ACTIVITY(7, "开卡活动"),
    SIGN_ACTIVITY(8, "签到活动"),
    CONSUME_ACTIVITY(9, "消费活动"),
    LEVEL_UP_ACTIVITY(10, "升级活动"),
    RECHARGE_ACTIVITY(11, "充值活动"),
    ORDER_EVALUATE_ACTIVITY(12, "订单评价活动"),

    PERFECT_INFO_TASK(13, "完善资料任务"),
    QUESTION_TASK(14, "调查问卷任务"),
    SHARE_TASK(15, "分享任务"),
    INVITE_TASK(16, "邀约任务");
    private Integer code;

    private String msg;

    GrowthBusinessTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getBusinessTypeMessage(Integer code) {
        for (GrowthBusinessTypeEnum type : GrowthBusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }

}
