package com.bizvane.members.facade.service.api;


import com.bizvane.members.facade.models.PayLevelRechargeSearchRequestVO;
import com.bizvane.members.facade.models.PayLevelRechargeSearchResponseVO;
import com.bizvane.members.facade.models.po.MbrLevelRechargeRecordPO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;
import java.util.Optional;

public interface MbrLevelRechargeService {


    ResponseData<PageInfo<PayLevelRechargeSearchResponseVO>> getPayLevelRechargeList(PayLevelRechargeSearchRequestVO payLevelRechargeSearchRequestVO);


    ResponseData<String> exportPayLevelRechargeList(PayLevelRechargeSearchRequestVO payLevelRechargeSearchRequestVO, Optional<SysAccountPO> optional);

    /**
     * 给365充值会员发券
     * @param mp
     * @return
     * @throws Exception
     */
    Boolean sendCoupon(MbrLevelRechargeRecordPO mp) throws Exception;
    /**
     * 付费会员卡等级充值退款
     * @param levelRechargeRecordId
     * @param sysAccountPO
     * @return
     */
    ResponseData<List<PayLevelRechargeSearchResponseVO>> refundPayLevelRecharge(Long levelRechargeRecordId, SysAccountPO sysAccountPO);

    /**
     * 付费会员卡等级充值记录查询
     * @param payLevelRechargeSearchRequestVO
     * @return
     */
    ResponseData<List<PayLevelRechargeSearchResponseVO>> getPLRechargeList(PayLevelRechargeSearchRequestVO payLevelRechargeSearchRequestVO);
}
