package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BaisonMemberResponseVo {
    @ApiModelProperty(value = "会员卡号", name = "vip_code")
    private String vip_code;
    @ApiModelProperty(value = "电话号码", name = "tel")
    private Integer tel;
    @ApiModelProperty(value = "顾客名称", name = "customer_name")
    private String customer_name;
    @ApiModelProperty(value = "渠道代码(注册渠道)", name = "org_code")
    private String org_code;
    @ApiModelProperty(value = "店铺代码", name = "shop_code")
    private String shop_code;
    @ApiModelProperty(value = "注册店员", name = "reg_user_code")
    private String reg_user_code;
    @ApiModelProperty(value = "性别（1：男 2：女）", name = "customer_sex")
    private String customer_sex;
    @ApiModelProperty(value = "顾客类型", name = "customer_type")
    private String customer_type;
    @ApiModelProperty(value = "顾客等级", name = "customer_level")
    private String customer_level;
    @ApiModelProperty(value = "生日", name = "birthday")
    private Date birthday;
    @ApiModelProperty(value = "会员卡系列", name = "series_code")
    private String series_code;
    @ApiModelProperty(value = "会员来源(必填字段)", name = "source")
    private String source;
    @ApiModelProperty(value = "国家", name = "country")
    private String country;
    @ApiModelProperty(value = "省份", name = "province")
    private String province;
    @ApiModelProperty(value = "城市", name = "city")
    private String city;
    @ApiModelProperty(value = "地区", name = "district")
    private String district;
    @ApiModelProperty(value = "地址", name = "address")
    private String address;
    @ApiModelProperty(value = "邮件地址", name = "email")
    private String email;
    @ApiModelProperty(value = "添加时间", name = "is_add_time")
    private Date is_add_time;
    @ApiModelProperty(value = "备注", name = "remark")
    private String remark;
    @ApiModelProperty(value = "当前积分", name = "integral")
    private Integer integral;
    @ApiModelProperty(value = "累计消费金额", name = "consume_money")
    private Float consume_money;
    @ApiModelProperty(value = "累计消费次数", name = "consume_num")
    private Integer consume_num;
    @ApiModelProperty(value = "累计消费商品数量", name = "consume_goods_num")
    private Integer consume_goods_num;
    @ApiModelProperty(value = "头像地址", name = "headphoto")
    private String headphoto;
    @ApiModelProperty(value = "发卡商店代码", name = "card_issuing_shop_code")
    private String card_issuing_shop_code;
    @ApiModelProperty(value = "储值卡是否启用", name = "prepaid_card_able")
    private Integer prepaid_card_able;
    @ApiModelProperty(value = "储值卡余额", name = "left_money")
    private Integer left_money;
    @ApiModelProperty(value = "锁定积分", name = "lock_integral")
    private Integer lock_integral;
    @ApiModelProperty(value = "可用积分", name = "useable_integral")
    private Integer useable_integral;
    @ApiModelProperty(value = "累计消费积分", name = "consume_integral")
    private Integer consume_integral;
    @ApiModelProperty(value = "发卡日期", name = "card_issuing_date")
    private Date card_issuing_date;
    @ApiModelProperty(value = "VIP卡状态 0-未启用 1-正常 2-停用,4-挂失,5-休眠", name = "status")
    private Integer status;
    @ApiModelProperty(value = "折扣", name = "discount")
    private Integer discount;
    @ApiModelProperty(value = "是否是员工", name = "is_staff")
    private Integer is_staff;
    @ApiModelProperty(value = "剩余员工可用折扣金额", name = "staff_discount_money")
    private Float staff_discount_money;
}
