package com.bizvane.members.facade.service.card;

import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.members.facade.enums.IntegralConsumeTypeEnum;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/18.
 */
@Slf4j
public abstract class ApiIntegralChangeServiceAbstract {


    /**
     * 验证数据有效性
     *
     * @param integralChangeRequestModel
     * @return
     */
    public abstract void validationData(IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 调用线下积分变动接口
     *
     * @param integralChangeRequestModel
     * @return
     */
    public abstract IntegralChangeResponseModel invokeOfflineChange(IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 积分变动操作
     *
     * @param integralChangeRequestModel
     * @return
     */
    @Transactional
    public IntegralChangeResponseModel integralChange(IntegralChangeRequestModel integralChangeRequestModel) {
        //验证数据有效性
        this.validationData(integralChangeRequestModel);

        //调用线下积分变动接口
        IntegralChangeResponseModel integralChangeResponseModel = this.invokeOfflineChange(integralChangeRequestModel);
        //线下操作成功返回
        if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode()) {
            try {
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                integralChangeResponseModel = invokeOnlineSyncData(integralChangeRequestModel, integralChangeResponseModel, memberInfoModel);
                if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode() && StringUtils.isNotBlank(
                        integralChangeResponseModel.getIntegralAdjustId())) {

                    // 获取变更后积分用来发消息 1 减积分 2 加积分
                    if ("1".equals(integralChangeRequestModel.getChangeType())) {
                        memberInfoModel.setCountIntegral(memberInfoModel.getCountIntegral() -integralChangeRequestModel.getChangeIntegral());
                    } else if ("2".equals(integralChangeRequestModel.getChangeType())){
                        memberInfoModel.setCountIntegral(memberInfoModel.getCountIntegral() + integralChangeRequestModel.getChangeIntegral());
                    }

                    log.info("发送通知消息:integralChangeResponseModel:{},memInfoModel:{}", JacksonUtil.bean2Json(integralChangeRequestModel), JacksonUtil.bean2Json(memberInfoModel));
                    asyncProcessMessage(integralChangeResponseModel, memberInfoModel);
                }
                return integralChangeResponseModel;
            } catch (MemberException me) {
                log.error(me.getMessage());
                me.getStackTrace();
                integralChangeResponseModel = new IntegralChangeResponseModel();
                integralChangeResponseModel.setCode(SysResponseEnum.FAILED.getCode());
                integralChangeResponseModel.setMessage(me.getMessage());

                integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.UNKNOW.getCode());
                integralChangeResponseModel.setErrorMessage(me.getMessage());
            }
        }
        //线下操作失败返回
        log.info("invokeOfflineChange 失败信息: " + integralChangeResponseModel.toString());
        return integralChangeResponseModel;
    }

    /**
     * 同步线上数据
     *
     * @param integralChangeRequestModel
     */
    public abstract IntegralChangeResponseModel invokeOnlineSyncData(IntegralChangeRequestModel integralChangeRequestModel, IntegralChangeResponseModel integralChangeResponseModel, MemberInfoModel memberInfoModel);

    private void asyncProcessMessage(IntegralChangeResponseModel instance, MemberInfoModel memberInfoModel) {
        new Thread(() -> this.notifySendMessage(instance, memberInfoModel)).start();
    }

    //同步消息和活动任务
    protected abstract void notifySendMessage(IntegralChangeResponseModel instance, MemberInfoModel memberInfoModel) throws MemberException;
}
