package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrCompanyWxGroupModel;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.models.MbrGroupTypeModel;
import com.bizvane.members.facade.vo.MbrGroupTypeVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxGroupRequestVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxGroupResponseVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxGroupSearchRequestVo;
import com.bizvane.members.facade.vo.qywx.GroupFirstLevelResponseVo;
import com.bizvane.members.facade.vo.qywx.MainIndexResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 企业微信会员分组设置api
 */

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CompanyWxGroupSetApiService {

	// 首页列表取6个常用二级分组
	@RequestMapping(value = "/api/companyWxGroup/get6MainIndexGroup", method = RequestMethod.POST)
	//作废
	ResponseData<List<MainIndexResponseVo>> get6MainIndexSecondGroup(@RequestParam(value = "brandId") Long brandId,
			@RequestParam(value = "storeId") Long storeId) throws MemberException;

	@RequestMapping(value = "/api/companyWxGroup/get6MainIndexSecondGroupNew", method = RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> get6MainIndexSecondGroupNew(
			@RequestBody CompanyWxGroupRequestVo companyWxGroupRequestVo) throws MemberException;

	// 品牌下所有一级分组
	@RequestMapping(value = "/api/companyWxGroup/getAllFirstLevelGroup", method = RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> getAllFirstLevelGroup(@RequestParam(value = "brandId") Long brandId)
			throws MemberException;

	// 一级分组下的所有二级分组
	@RequestMapping(value = "/api/companyWxGroup/getSecondGroupByFirstLevelGroup", method = RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> getSecondGroupByFirstLevelGroup(
			@RequestBody CompanyWxGroupRequestVo companyWxGroupRequestVo) throws MemberException;

	// 查二级分组下的会员
	@RequestMapping(value = "/api/companyWxGroup/getGroupMembers", method = RequestMethod.POST)
	ResponseData<CompanyWxGroupResponseVo> getGroupMembers(@RequestBody CompanyWxGroupRequestVo companyWxGroupRequestVo)
			throws MemberException;

	// 搜索二级分组
	@RequestMapping(value = "/api/companyWxGroup/searchGroup", method = RequestMethod.POST)
	ResponseData<List<GroupFirstLevelResponseVo>> searchGroup(
			@RequestBody CompanyWxGroupSearchRequestVo companyWxGroupSearchRequestVo);

}
