package com.bizvane.members.facade.models.po;

import com.bizvane.members.facade.models.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class MbrUniversalBindChannelPo extends BaseModel {
    /**
    * 主键id
    */
    @ApiModelProperty(value="主键id")
    private Long mbrUniversalBindId;

    /**
    * 企业id
    */
    @ApiModelProperty(value="企业id")
    private Long sysCompanyId;

    /**
    * 品牌id
    */
    @ApiModelProperty(value="品牌id")
    private Long brandId;

    /**
    * 会员code
    */
    @ApiModelProperty(value="会员code")
    private String memberCode;

    /**
    * 渠道类型,1:商帆商城 2:微盟商城 3:有赞商城 4:linkflow 5:京东会员通
    */
    @ApiModelProperty(value="渠道类型,1:商帆商城 2:微盟商城 3:有赞商城 4:linkflow 5:京东会员通")
    private Integer channelType;

    /**
    * 是否绑定,1：未绑定,2：已绑定,3:已解绑
    */
    @ApiModelProperty(value="是否绑定,1：未绑定,2：已绑定,3:已解绑")
    private Integer bindType;

    /**
    * 推广渠道来源,子渠道,来源渠道记录
    */
    @ApiModelProperty(value="推广渠道来源,子渠道,来源渠道记录")
    private String subChannelSource;

    /**
    * 是否开卡渠道：1是，0不是
    */
    @ApiModelProperty(value="是否开卡渠道：1是，0不是")
    private Boolean channelOpenCard;

    /**
    * 第三方渠道unionid
    */
    @ApiModelProperty(value="第三方渠道unionid")
    private String unionId;

    /**
    * 第三方渠道openid
    */
    @ApiModelProperty(value="第三方渠道openid")
    private String openId;

    /**
    * 开卡门店code
    */
    @ApiModelProperty(value="开卡门店code")
    private Long openCardStoreCode;

    /**
    * 开卡导购code
    */
    @ApiModelProperty(value="开卡导购code")
    private Long openCardGuideCode;

    /**
    * 渠道昵称
    */
    @ApiModelProperty(value="渠道昵称")
    private String nick;

    /**
    * 渠道头像
    */
    @ApiModelProperty(value="渠道头像")
    private String headPortraits;

    /**
    * 性别,女：0 男：1
    */
    @ApiModelProperty(value="性别,女：0 男：1")
    private String gender;

    /**
    * 省份
    */
    @ApiModelProperty(value="省份")
    private String province;

    /**
    * 城市
    */
    @ApiModelProperty(value="城市")
    private String city;

    /**
    * 区县
    */
    @ApiModelProperty(value="区县")
    private String county;

    /**
    * 绑定时间
    */
    @ApiModelProperty(value="绑定时间")
    private Date bindTime;

    /**
    * 解绑时间
    */
    @ApiModelProperty(value="解绑时间")
    private Date unbindTime;

    /**
    * 渠道分享人openid
    */
    @ApiModelProperty(value="渠道分享人openid")
    private String referrerOpenid;


}