package com.bizvane.members.facade.es.vo;

import com.bizvane.members.facade.enums.MemberFieldEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
@ApiModel(value = "会员polarDb搜索标准")
public class DbFlexibleSearchVo {


    //group1-----会员返回字段及排序方式
    @ApiModelProperty(name = "memberFieldEnums", value = "会员组合返回字段")
    private MemberFieldEnum[] memberFieldEnums = {MemberFieldEnum.defaultField};


    //group2----查询条件
    @ApiModelProperty(name = "sysCompanyId", value = "公司id")
    @NotNull
    private Long sysCompanyId;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    @NotNull
    private Long brandId;

    @ApiModelProperty(name = "memberCode", value = "会员code")
    private String memberCode;

    @ApiModelProperty(name = "cardNo", value = "卡号")
    private String cardNo;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    @ApiModelProperty(name = "erpId", value = "erpId")
    private String erpId;

    @ApiModelProperty(name = "unionId", value = "unionId")
    private String unionId;

}
