package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.models.bo.CompanyWxChannelInfoBo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * Created by Administrator on 2018\7\10 0010. 微信渠道信息 外部使用
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface WxChannelInfoApiService {

    /**
     * 获取微信渠道信息
     *
     * @param wxChannelInfoVo
     * @return
     */
    @RequestMapping(value = "/api/getWxChannelInfo", method = RequestMethod.POST)
    ResponseData<WxChannelInfoVo> getWxChannelInfo(@RequestBody WxChannelInfoVo wxChannelInfoVo) throws MemberException;

    /**
     * 插入微信渠道信息
     *
     * @param wxChannelInfoVo
     * @return
     */
    @RequestMapping(value = "/api/insertWxChannelInfo", method = RequestMethod.POST)
    ResponseData insertWxChannelInfo(@RequestBody WxChannelInfoVo wxChannelInfoVo) throws MemberException;

    /**
     * 修改微信渠道信息
     *
     * @param wxChannelInfoVo
     * @return
     */
    @RequestMapping(value = "/api/updateWxChannelInfo", method = RequestMethod.POST)
    ResponseData updateWxChannelInfo(@RequestBody WxChannelInfoVo wxChannelInfoVo) throws MemberException;

    /**
     * 修改微信渠道信息(根据openid修改)
     *
     * @param wxChannelInfoVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateWxChannelInfoByOpenid", method = RequestMethod.POST)
    ResponseData updateWxChannelInfoByOpenid(@RequestBody WxChannelInfoVo wxChannelInfoVo) throws MemberException;

    /**
     * 获取用户是否微信会员
     *
     * @param openId 微信openid
     * @param appid  appid
     * @return 1当前用户不是微信会员 2当前用户是微信会员(如果用户当前状态为NULL,则默认为1)
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryMemberStatus", method = RequestMethod.POST)
    @Deprecated
    ResponseData<Integer> queryMemberStatus(@RequestParam(value = "openId") String openId,
                                            @RequestParam(value = "appid") String appid) throws MemberException;

    /**
     * 查询微信粉丝会员数据
     *
     * @param brandId
     * @return
     */
    @RequestMapping(value = "/api/queryWeChatFansAndMemberByBrandId", method = RequestMethod.POST)
    @Deprecated
    ResponseData<PageInfo<WxChannelInfoVo>> queryWeChatFansAndMemberByBrandId(@RequestBody PageVo pageVo,
                                                                              @RequestParam(value = "brandId") Long brandId);

    /**
     * 插入微信粉丝
     *
     * @param wxChannelInfoModel
     * @return
     */
    @RequestMapping(value = "/api/insertWeChatFans")
    @Deprecated
    ResponseData<Integer> insertWeChatFans(@RequestBody WxChannelInfoModel wxChannelInfoModel);

    /**
     * 获取微信渠道信息(争光用)
     *
     * @param wxChannelInfoVo
     * @return
     */
    @RequestMapping(value = "/api/getWxChannelInfoForWX", method = RequestMethod.POST)
    ResponseData<WxChannelInfoVo> getWxChannelInfoForWX(@RequestBody WxChannelInfoVo wxChannelInfoVo)
            throws MemberException;

    /**
     * 通过appid,brandid,openid获取微信渠道信息
     *
     * @param wxChannelInfoVo
     * @return
     */
    @RequestMapping(value = "/api/getWxChannelInfoByWX", method = RequestMethod.POST)
    ResponseData<WxChannelInfoVo> getWxChannelInfoByWX(@RequestBody WxChannelInfoVo wxChannelInfoVo)
            throws MemberException;

    /**
     * 插入微信渠道信息(争光用)
     *
     * @param wxChannelInfoVo
     * @return
     */
    @RequestMapping(value = "/api/insertWxChannelInfoForWX", method = RequestMethod.POST)
    ResponseData insertWxChannelInfoForWX(@RequestBody WxChannelInfoVo wxChannelInfoVo) throws MemberException;

    /**
     * (取消关注) 修改微信渠道信息(根据openid修改)(争光用)
     *
     * @param wxChannelInfoVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateWxChannelInfoByOpenidForWX", method = RequestMethod.POST)
    ResponseData updateWxChannelInfoByOpenidForWX(@RequestBody WxChannelInfoVo wxChannelInfoVo) throws MemberException;

    /**
     * 根据会员code 品牌id，公司id查询会员信息
     *
     * @param wxChannelRelationVo
     * @return
     */
    @RequestMapping(value = "/api/getWxChannelInfoRelation")
    ResponseData<WxChannelInfoModel> getWxChannelInfoRelation(@RequestBody WxChannelRelationVo wxChannelRelationVo);

    /**
     * 根据会员code 查询微信openid(俊伟用)
     *
     * @param memberCode
     * @return
     */
    @RequestMapping(value = "/api/getWxOpenIdByMemberCode", method = RequestMethod.POST)
    ResponseData<String> getWxOpenIdByMemberCode(@RequestParam(value = "memberCode") String memberCode);

    /**
     * 获取微信渠道信息和会员信息
     *
     * @param wxChannelInfoVo
     * @return
     */
    @RequestMapping(value = "/api/getWxChannelInfoAndMemberInfo", method = RequestMethod.POST)
    ResponseData<WxChannelAndMemberVo> getWxChannelInfoAndMemberInfo(@RequestBody WxChannelInfoVo wxChannelInfoVo)
            throws MemberException;

    /**
     * 获取微信渠道信息
     *
     * @return
     */
    @RequestMapping(value = "/api/getWxChannelInfoByOpenCardGuideId", method = RequestMethod.POST)
    @Deprecated
    ResponseData<List<CompanyWxChannelInfoBo>> getWxChannelInfoByOpenCardGuideId(
            @RequestParam(value = "openCardGuideId") Long openCardGuideId,
            @RequestParam(value = "baseSearchValue", required = false) String baseSearchValue);

}
