package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/7/14 18:39
 * @Description:会员等级实体
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_level_def")
public class MbrLevelModel extends BaseModel {

    private static final long serialVersionUID = -7226173529088836771L;

    @Id
    @ApiModelProperty(value = "等级id", name = "mbrLevelId", example = "等级id")
    private Long mbrLevelId;

    @ApiModelProperty(value = "归属企业", name = "sysCompanyId", example = "归属企业")
    private Long sysCompanyId;

    @ApiModelProperty(value = "公众号id", name = "publicId", example = "公众号id")
    private Long publicId;

    @ApiModelProperty(value = "所属品牌", name = "brandId", example = "所属品牌")
    private Long brandId;

    @ApiModelProperty(value = "等级编号", name = "levelCode", example = "等级编号")
    private String levelCode;

    @ApiModelProperty(value = "等级名称", name = "levelName", example = "等级名称")
    private String levelName;

    @ApiModelProperty(value = "等级别名", name = "levelAliasName", example = "等级别名")
    private String levelAliasName;

    @ApiModelProperty(value = "线下等级code", name = "offlineLevelCode", example = "线下等级code")
    private String offlineLevelCode;

    @ApiModelProperty(value = "等级值", name = "levelValue", example = "等级值")
    private Integer levelValue;

    @ApiModelProperty(value = "等级类型(1=标准卡;2=特殊卡;特殊卡不参与等级排序)", name = "levelType", example = "等级类型(1=标准卡;2=特殊卡;特殊卡不参与等级排序)")
    private String levelType;

    @ApiModelProperty(value = "有效期限/单位月", name = "levelIndate", example = "有效期限/单位月")
    private Integer levelIndate;

    @ApiModelProperty(value = "折扣计算方式: 0=就低原则;1=折上折原则", name = "discountMethod", example = "折扣计算方式: 0=就低原则;1=折上折原则")
    private Integer discountMethod;

    @ApiModelProperty(value = "会员折扣", name = "memberDiscount", example = "会员折扣")
    private Integer memberDiscount;

    @ApiModelProperty(value = "折上折", name = "additionalDiscount", example = "折上折")
    private Integer additionalDiscount;

    @ApiModelProperty(value = "积分计算规则:1=向上取整;2=四舍五入;3=向下取整", name = "calculateRule", example = "积分计算规则:1=向上取整;2=四舍五入;3=向下取整")
    private Integer calculateRule;

    @ApiModelProperty(value = "积分比例（元）", name = "ratioMoney", example = "积分比例（元）")
    private Integer ratioMoney;

    @ApiModelProperty(value = "积分比例 （积分）", name = "ratioIntegral", example = "积分比例 （积分）")
    private Integer ratioIntegral;

    @ApiModelProperty(value = "上级等级编号", name = "superiorLevelCode", example = "上级等级编号")
    private String superiorLevelCode;

    @ApiModelProperty(value = "升级门槛时间", name = "upgradeLevelTime", example = "升级门槛时间")
    private String upgradeLevelTime;

    @ApiModelProperty(value = "升级门槛-消费金额", name = "upgradeLevelMoney", example = "升级门槛-消费金额")
    private Long upgradeLevelMoney;

    @ApiModelProperty(value = "保留等级时间", name = "keepLevelTime", example = "保留等级时间")
    private String keepLevelTime;

    @ApiModelProperty(value = "保留等级金额", name = "keepLevelMoney", example = "保留等级金额")
    private Long keepLevelMoney;

    @ApiModelProperty(value = "降级等级编号", name = "demotionLevelCode", example = "降级等级编号")
    private String demotionLevelCode;

    @ApiModelProperty(value = "会员卡权益状态: 1=启用 0=禁用", name = "status", example = "会员卡权益状态: 1=启用 0=禁用")
    private Integer status;

    @ApiModelProperty(value = "商品折扣控制,1=全部适用;2=部分适用;", name = "discountControl", example = "商品折扣控制,1=全部适用;2=部分适用;")
    private Integer discountControl;

    @ApiModelProperty(value = "适用商品折扣率max", name = "discountMax", example = "适用商品折扣率max")
    private Integer discountMax;

    @ApiModelProperty(value = "适用商品折扣率min", name = "discountMin", example = "适用商品折扣率min")
    private Integer discountMin;

    @ApiModelProperty(value = "等级升降级说明", name = "levelRemark", example = "等级升降级说明")
    private String levelRemark;

    @ApiModelProperty(value="智慧门店等级名称",name="taobaoLevelName",example="智慧门店等级名称")
    private String taobaoLevelName;

    @ApiModelProperty(value="智慧门店等级code",name="taobaoLevelCode",example="智慧门店等级code")
    private String taobaoLevelCode;

//    @ApiModelProperty(value="升级状态",name="upDownType",example="升级状态")
//    private Integer upStatus;

    @ApiModelProperty(value="升级条件",name="upGrade",example="升级条件")
    private String upGradeCondition;

    @ApiModelProperty(value="升级月数量",name="upGrade",example="升级月数量")
    private Integer  upMonthNum;

//    @ApiModelProperty(value="保级状态",name="upDownType",example="保级状态")
//    private Integer keepStatus;

    @ApiModelProperty(value="保级条件",name="upGrade",example="保级条件")
    private String keepGradeCondition;

    @ApiModelProperty(value="保级月数量",name="upGrade",example="保级月数量")
    private Integer  keepMonthNum;

    @ApiModelProperty(value="抵扣比例",name="upGrade",example="抵扣比例")
    private BigDecimal discountRatio;

    @ApiModelProperty(value = "是否付费卡 0否 1是",name = "payFlag")
    private Integer payFlag;

    @ApiModelProperty(value = "入会费",name = "payMoney")
    private BigDecimal payMoney;

    @ApiModelProperty(value = "有效期 年",name = "effectiveYear")
    private Integer effectiveYear;

    @ApiModelProperty(value = "'到期等级变更 0变更到新等级 1到期变更到原等级',",name = "levelChangeType")
    private Integer levelChangeType;

    @ApiModelProperty(value = "如果是到期变更到新等级 此处为新等级id",name = "newLevelId")
    private Long newLevelId;

    @ApiModelProperty(value = "成长值升级临界点")
    private Integer growthLevelUpPoint;

    @ApiModelProperty(value = "限制购买条件0 不限制 1限制")
    private Integer payBuyLimitEnable;

    @ApiModelProperty(value = "限制等级id")
    private String payBuyLimitLevel;

    /**
     * 会员送券权益开关 0 关闭 1 开启
     */
    private Integer equityFlag;

    /**
     *  赠送周期 3个月、6个月、9个月、12个月 3 6 9 12
     */
    private Integer giveCycle;

    /**
     *  生效日期
     */
    private Date effectDate;

    /**
     * 券定义id,多个,分隔
     */
    private String couponIds;
}
