package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/16.
 */
public interface MemberIntegralRecordService {
    /**
     * 根据会员code查询积分流水
     *
     * @param integralRecordVo
     * @return
     */
    public ResponseData findIntegralRecordByMemberCode(PageVo pageVo, IntegralRecordVo integralRecordVo);

    /**
     * 积分流水明细查询
     *
     * @param pageVo
     * @param integralRecordModel
     * @return
     */
    ResponseData<PageInfo<IntegralRecordModel>> queryIntegralRecordList(PageVo pageVo, IntegralRecordModel integralRecordModel);

    /**
     * 查询积分流水列表
     *
     * @param integralRecordModel
     * @param start
     * @param size
     * @return
     */
    List<IntegralRecordModel> queryIntegralRecordList(IntegralRecordModel integralRecordModel, Long start, Long size);

    /**
     * 查询积分流水总数
     *
     * @param integralRecordModel
     * @return
     */
    Long queryRecordCount(IntegralRecordModel integralRecordModel);

    /**
     * 积分流水明细查询ES
     *
     * @param pageable
     * @param integralRecordModel
     * @return
     */
    PageInfo<IntegralRecordModel> queryIntegralRecordListES(IntegralRecordModel integralRecordModel, Pageable pageable);
}
