package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrOpenCardApiService {

    /**
     * 会员注册
     *
     * @param urMemberCardRequestVo
     * @return
     */
    @RequestMapping(path = "/urOpenCard/memberRegister", method = RequestMethod.POST)
    ResponseData<UrMemberCardResponseVo> memberRegister(@RequestBody @Valid UrMemberCardRequestVo urMemberCardRequestVo);

    /**
     * 会员查询
     *
     * @param urMemberQueryRequestVo
     * @return
     * @throws Exception
     */
    @RequestMapping(path = "/urOpenCard/memberQuery", method = RequestMethod.POST)
    ResponseData<UrMemberQueryResponseVo> memberQuery(@RequestBody @Valid UrMemberQueryRequestVo urMemberQueryRequestVo) throws Exception;

    /**
     * 更新会员信息
     *
     * @param urMemberUpdateInfoRequestVo
     * @return
     */
    @RequestMapping(path = "/urOpenCard/memberUpdateInfo", method = RequestMethod.POST)
    ResponseData<UrMemberUpdateInfoResponseVo> memberUpdateInfo(@RequestBody @Valid UrMemberUpdateInfoRequestVo urMemberUpdateInfoRequestVo);

    /**
     * 更新会员手机号
     *
     * @param urMemberUpdatePhoneRequestVo
     * @return
     */
    @RequestMapping(path = "/urOpenCard/memberUpdatePhone", method = RequestMethod.POST)
    ResponseData<UrMemberUpdatePhoneResponseVo> memberUpdatePhone(@RequestBody @Valid UrMemberUpdatePhoneRequestVo urMemberUpdatePhoneRequestVo);
}
