package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.sql.Timestamp;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BaisonRequestVo<T> {
    @ApiModelProperty(value = "方法名", name = "method")
    private String method;

    @ApiModelProperty(value = "加密key", name = "key")
    private String key;

    @ApiModelProperty(value = "当前时间戳", name = "time")
    private Date time;

    @ApiModelProperty(value = "签名加密(备注说明)", name = "sign")
    private String sign;

    private T params;

}
