package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.es.vo.AdvancedFlexibleSearchVo;
import com.bizvane.members.facade.es.vo.DbFlexibleSearchVo;
import com.bizvane.members.facade.models.AdvancedFlexibleResult;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface AdvancedFlexibleApiService {

    @PostMapping("/api/member/advancedFlexibleApi")
    ResponseData<AdvancedFlexibleResult> advancedFlexibleApi(@RequestBody @Valid AdvancedFlexibleSearchVo advancedFlexibleSearchVo);


    @PostMapping("/api/member/dbFlexibleApi")
    ResponseData<Map<String, Object>> dbFlexibleApi(@RequestBody @Valid DbFlexibleSearchVo dbFlexibleSearchVo);
    
}
