package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.ibatis.annotations.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/18 16:11
 * @Description: 积分流水接口
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface IntegralRecordApiService {

    /**
     * 会员积分变更接口
     *
     * @param integralRecordModel
     * @return
     * @throws MemberException
     */
//    @RequestMapping(value = "/api/updateMemberIntegral", method = RequestMethod.POST)
//    ResponseData updateMemberIntegral(@RequestBody IntegralRecordModel integralRecordModel) throws MemberException;

    /**
     * 查询任务积分总计:
     * 传入businessWay查询任务总积分
     * 传入changeBills查询单一任务总积分
     * 传入memberCode查询会员总获得积分
     *
     * @param integralRecordModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryIntegralCount", method = RequestMethod.POST)
    ResponseData<Integer> queryIntegralCount(@RequestBody IntegralRecordModel integralRecordModel) throws MemberException;

    /**
     *查询积分记录
     * @param integralRecordVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryIntegralRecord", method = RequestMethod.POST)
    ResponseData<List<IntegralRecordModel>> queryIntegralRecord(@RequestBody IntegralRecordVo integralRecordVo) throws MemberException;

    @RequestMapping(value = "/api/InsertIntegralRecord", method = RequestMethod.POST)
    public ResponseData<Integer> InsertIntegralRecord(@RequestBody IntegralRecordModel integralRecordModel) throws MemberException;

    @RequestMapping(value = "/api/queryRecordByOfflineId", method = RequestMethod.POST)
    ResponseData queryRecordByOfflineId(@RequestParam("sysCompanyId")Long sysCompanyId, @RequestParam("brandId")Long brandId, @RequestParam("offlineIntegralId") String offlineIntegralId) throws MemberException;
}
