package com.bizvane.members.facade.models.qywx;

import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 区经门店客户资产排产榜 请求Vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月27日 14:01:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AreaManagerAssetsRankReqVo {

    /**
     * 资产类型 1会员 2粉丝 3好友
     */
    @NotEmpty
    @ApiModelProperty(name = "assetsType", value = "资产类型 1会员 2粉丝 3好友")
    private Integer assetsType;

    /**
     * 查询类型 1 门店资产 2 导购资产
     */
    @NotEmpty
    @ApiModelProperty(name = "queryType",value = "查询类型 1 门店资产 2 导购资产")
    private Integer queryType;

    /**
     * 区域下 全部店铺idList
     */
    @ApiModelProperty(name = "storeIdList",value = "区域下 全部店铺idList")
    private List<Long> storeIdList;

    /**
     * 模糊查询店铺idList
     */
    @ApiModelProperty(name = "fuzzyQueryStoreIdList",value = "模糊查询店铺idList")
    private List<Long> fuzzyQueryStoreIdList;

    /**
     * 区域下 全部导购idList
     */
    @ApiModelProperty(name = "staffIdList",value = "区域下 全部导购idList")
    private List<Long> staffIdList;

    /**
     * 模糊查询导购idList
     */
    @ApiModelProperty(name = "fuzzyQueryStaffIdList",value = "模糊查询导购idList")
    private List<Long> fuzzyQueryStaffIdList;

    /**
     * 页数
     */
    @NotEmpty
    @ApiModelProperty(name = "pageNum",value = "页数")
    private Integer pageNum;

    /**
     * 单页数量
     */
    @NotEmpty
    @ApiModelProperty(name = "pageSize",value = "单页数量")
    private Integer pageSize;

    /**
     * sysCompanyId
     */
    @NotEmpty
    private Long sysCompanyId;

    /**
     * brandId
     */
    @NotEmpty
    private Long brandId;


}
