package com.bizvane.members.facade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 区经门店客户资产排产榜 返回Bo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月27日 11:34:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AreaManagerAssetsRankBo {

    /**
     * 排行
     */
    @ApiModelProperty(name="rankId",value = "排行")
    private Long rankId;

    /**
     * store/staff Id
     */
    @ApiModelProperty(name="id",value = "store/staff Id")
    private Long id;

    /**
     * store/staff code
     */
    @ApiModelProperty(name="code",value = "store/staff code")
    private String code;

    /**
     * store/staff name
     */
    @ApiModelProperty(name="name",value = "store/staff name")
    private String name;

    /**
     * 会员/粉丝/好友 资产总数
     */
    @ApiModelProperty(name="assetsCount",value = "会员/粉丝/好友 资产总数")
    private String assetsCount;

}
