package com.bizvane.members.facade.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;

/**
 * 导入手机号批量帖标签
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月23日 11:46:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ImportBatchAddLabelReqVo {
    /**
     * excel七牛云地址
     */
    @NotEmpty
    private String url;

    /**
     * 1 帖标签 2撕标签
     */
    @NotEmpty
    private Integer type;

    /**
     * 标签id
     */
    @NotEmpty
    private Long labelId;

    /**
     * 标签名称
     */
    @NotEmpty
    private String labelName;

}
