package com.bizvane.members.facade.models.qywx;

import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 区经门店客户资产排产榜 请求Vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月27日 14:01:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AreaManagerAssetsRankReqVo {

    /**
     * 资产类型 1会员 2粉丝 3好友
     */
    @NotEmpty
    private Integer assetsType;

    /**
     * 查询类型 1 门店资产 2 导购资产
     */
    @NotEmpty
    private Integer queryType;

    private List<Long> storeIdList;

    private List<Long> staffIdList;

    @NotEmpty
    private Integer pageNum;

    @NotEmpty
    private Integer pageSize;

}
