package com.bizvane.members.facade.service.datafetch.model;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Lijc
 */
@Data
public class AboutExpireIntegralFetchModel extends BaseFetchModel implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 会员code
     */
    private String memberCode;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long brandId;

    /**
     * 即将过期积分
     */
    private Integer aboutExpireIntegral;

    /**
     * 即将过期时间（积分清零时间）
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date aboutExpireTime;
}
