package com.bizvane.members.facade.service.api;


import com.bizvane.members.facade.es.pojo.qywx.MembersFriendPojo;
import com.bizvane.members.facade.es.vo.MemberAssetsCounterResponseVo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.query.MemberAssetsCounterRequestPo;
import com.bizvane.members.facade.models.query.MemberAssetsViewRequestPo;
import com.bizvane.members.facade.models.qywx.WxQyFriendsResponseVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.io.IOException;
import java.util.concurrent.ExecutionException;

/**
 * 提供商秀会员接口
 * 客户资源分析需求
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MemberBizvaneShowAssetsService {


    /**
     * 以导购或门店维度 查询会员/非会员   微信/公众号/好友 总数
     * @return
     */
    @RequestMapping(value = "/api/guideOrStoreSingleton", method = RequestMethod.POST)
    ResponseData<MemberAssetsCounterResponseVo> findWPFCounterByGuideOrStoreSingleton(@RequestBody MemberAssetsCounterRequestPo memberAssetsRequestPo) throws MemberException;


    /**
     * 以导购或门店维度 查询会员/非会员   微信/公众号/好友 列表
     * @return
     */
    @RequestMapping(value = "/api/guideOrStoreList", method = RequestMethod.POST)
    ResponseData<PageInfo<MembersFriendPojo>> findWPFInformationByGuideOrStoreList(@RequestBody MemberAssetsViewRequestPo memberAssetsViewRequestPo) throws MemberException;
}
