package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.po.MbrLevelRechargePO;
import com.bizvane.members.facade.vo.LevelCardResponseVO;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @Author: houkai
 * @Date: 2018/7/14 18:46
 * @Description:
 */
public interface MemberLevelService {
    /**
     * 新建会员等级
     *
     * @param mbrLevelModel
     * @return
     * @throws MemberException
     */
    ResponseData addLevel(SysAccountPO stageUser,MbrLevelModel mbrLevelModel) throws MemberException, ParseException;

    /**
     * 查询会员等级基本信息
     *
     * @param mbrLevelId
     * @return
     */
    ResponseData<MbrLevelModel> queryLevelBasicInfo(long mbrLevelId);

    /**
     * 编辑会员等级基本信息
     *
     * @param mbrLevelModel
     * @return
     * @throws MemberException
     */
    ResponseData updateLevel(MbrLevelModel mbrLevelModel) throws MemberException, ParseException;

    /**
     * 会员卡权益启用禁用
     *
     * @param mbrLevelModel
     * @return
     * @throws MemberException
     */
    ResponseData updateLevelStatus(MbrLevelModel mbrLevelModel) throws MemberException;

    /**
     * 根据品牌id查询会员卡等级
     *
     * @param brandId
     * @param source  判断请求来源,null本地,非null会员通
     * @return
     */
    ResponseData<List<MbrLevelModel>> queryLevelList(Long brandId, String source);

    /**
     * 生成等级编号
     *
     * @return
     */
    String getLevelCode();

    /**
     * 查询会员等级使用人数
     *
     * @param mbrLevelId
     * @return
     */
    ResponseData queryLevelCount(long mbrLevelId);

    /**
     * 调整会员等级排序
     *
     * @param mbrLevelModel
     * @return
     */
    ResponseData updateLevelSort(MbrLevelModel mbrLevelModel) throws ParseException;

    /**
     * 删除会员等级
     *
     * @param mbrLevelModel
     * @return
     */
    ResponseData deleteLevel(MbrLevelModel mbrLevelModel);

    /**
     * 查询品牌下所有等级Map
     * @param brandId
     * @return
     */
    Map<Long,String> queryLevelMap(Long brandId);

    /**
     * 会员等级分页
     * @param pageVo
     * @param brandId
     * @param source
     * @return
     */
    public  ResponseData<PageInfo<MbrLevelModel>>  queryLevelListPage(PageVo pageVo, Long brandId, String source);


    /**
     * 查询非付费卡等级id
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    ResponseData<List<LevelCardResponseVO>> queryNonPayLevelCard(Long sysCompanyId, Long brandId,Long currentLevelId);

    /**
     * 查询付费卡等级id
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    ResponseData<List<LevelCardResponseVO>> queryPayLevelCard(Long sysCompanyId,Long brandId);


    /**
     * 付费卡到期
     * @param mbrLevelRechargePO
     * @return
     */
    ResponseData<String> payLevelCardExpireSPI(MbrLevelRechargePO mbrLevelRechargePO);

    /**
     * 更改会员等级
     * @param erpIds
     * @param sysCompanyId
     * @param sysBrandId
     * @param levelId
     * @return
     */
    ResponseData changeMbrLevelId(String erpIds, Long sysCompanyId, Long sysBrandId, Long levelId);
}
