package com.bizvane.members.facade.service.inner;

/**
 * @author dingShiChen
 * @since 2019/10/23
 */
public interface IntegralRecordBusinessTypeService {

	/**
	 * 根据商帆规则code获取描述
	 * @param bizvaneBusinessCode 商帆规则的code
	 * @return
	 */
	String findByBizvaneCode(String bizvaneBusinessCode);

	/**
	 * 根据code获取描述
	 * @param businessCode
	 * @param sysCompanyId
	 * @return
	 */
	String findByCode(String businessCode, Long sysCompanyId);


	/**
	 * 兼容普通code和bizvane-开头的code
	 * @param businessCode
	 * @param sysCompanyId
	 * @return
	 */
	String findByCodeCompatibility(String businessCode,Long sysCompanyId);
}
