package com.bizvane.members.facade.enums;

public enum GrowthBusinessTypeEnum {

    ADJUST_MANUAL(0, "手动调整"),
    ORDER_PRICE_GROWTH(1, "订单金额增加"),
    ORDER_NUM_GROWTH(2, "订单次数增加"),
    ORDER_REFUND_PRICE_GROWTH(3, "退单金额扣减"),
    ORDER_REFUND_NUM_GROWTH(4, "退单次数扣减"),
    LAST_90_NOT_CONSUME_GROWTH(5, "最近90未消费扣减"),
    LAST_30_NOT_CONSUME_GROWTH(6, "最近30天未消费扣减");
    private Integer code;

    private String msg;

    GrowthBusinessTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getBusinessTypeMessage(Integer code) {
        for (GrowthBusinessTypeEnum type : GrowthBusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }

}
