package com.bizvane.members.facade.vo;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class CommonOrderRequestVo {

    private Long sysCompanyId;//非openApi接口字段 attention!!!



    @NotNull
    private String brandCode;//		是	string	品牌id
    @NotNull
    private Integer orderFlag;//		是	string	1是订单2是退单

    private String phone;//		是	string	会员手机号
    @NotNull
    private String erpId;//		是	string	会员唯一标识(类似于主键id、会员code、costomerCode等)
    @NotNull
    private String orderNo;//		是	string	订单号

    private String originalOrderNo;//原始订单
    @NotNull
    private Integer orderFrom;//		是	int	订单来源 : 1.POS(门店) 2.商城

    private BigDecimal commodityAmount;//		否	decimal	商品金额 成交总额

    private BigDecimal tradeAmount;//		否	decimal	成交金额(优惠卷+抵扣卷+打折)

    private BigDecimal preferentialAmount;//		否	decimal	优惠券优惠金额

    private BigDecimal deductibleAmount;    //	否	decimal	积分抵扣金额

    @NotNull
    private Date placeOrderTime;//		否	dateTime	下单时间

    private Date payTime;//		否	dateTime	支付时间

    private BigDecimal payMoney;//		否	decimal	支付金额

    private Integer usedIntegral;//		否	int	使用积分

    private Integer productCount;//		否	int	商品数量(发货数量)

    private Date sendTime;//		否	dateTime	发货时间

    private String storeCode;//		否	string	店铺Code

    private String storeName;//		否	string	店铺名称

    private String serviceStoreSite;//  线下店铺地址

    private String guideCodes;        //否	string	店铺服务导购Code

    private String guideNames;//	否	string	店铺导购名称

    private List<CommonOrderCouponInfo> couponInfo;//		否	string	关联优惠券

    private List<CommonOrderDetail> orderDetail;//		否	string	关联订单明细

    private List<CommonOrderPayment> orderPayMent;//		否	string	关联支付明细

    private String buyerRemark;//		否	string	买家备注
    private String remark;//		否	string	备注


    //是否允许非会销订单进入(mq重试次数超过十次)
    private Boolean allowNonMember;

}
