/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.enums.IntegralConsumeTypeEnum;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class ApiIntegralChangeServiceAbstract {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralChangeServiceAbstract.class);

    public abstract void validationData(IntegralChangeRequestModel var1);

    public abstract IntegralChangeResponseModel invokeOfflineChange(IntegralChangeRequestModel var1);

    @Transactional
    public IntegralChangeResponseModel integralChange(IntegralChangeRequestModel integralChangeRequestModel) {
        this.validationData(integralChangeRequestModel);
        IntegralChangeResponseModel integralChangeResponseModel = this.invokeOfflineChange(integralChangeRequestModel);
        if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode().intValue()) {
            try {
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                integralChangeResponseModel = this.invokeOnlineSyncData(integralChangeRequestModel, integralChangeResponseModel, memberInfoModel);
                if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode().intValue() && StringUtils.isNotBlank((CharSequence)integralChangeResponseModel.getIntegralAdjustId())) {
                    log.info("\u53d1\u9001\u901a\u77e5\u6d88\u606f:integralChangeResponseModel:{},memInfoModel:{}", (Object)JacksonUtil.bean2Json((Object)integralChangeRequestModel), (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
                    this.asyncProcessMessage(integralChangeResponseModel, memberInfoModel);
                }
                return integralChangeResponseModel;
            }
            catch (MemberException me) {
                log.error(me.getMessage());
                me.getStackTrace();
                integralChangeResponseModel = new IntegralChangeResponseModel();
                integralChangeResponseModel.setCode(SysResponseEnum.FAILED.getCode());
                integralChangeResponseModel.setMessage(me.getMessage());
                integralChangeResponseModel.setErrorStatus(IntegralConsumeTypeEnum.UNKNOW.getCode());
                integralChangeResponseModel.setErrorMessage(me.getMessage());
            }
        }
        log.info("invokeOfflineChange \u5931\u8d25\u4fe1\u606f: " + integralChangeResponseModel.toString());
        return integralChangeResponseModel;
    }

    public abstract IntegralChangeResponseModel invokeOnlineSyncData(IntegralChangeRequestModel var1, IntegralChangeResponseModel var2, MemberInfoModel var3);

    private void asyncProcessMessage(IntegralChangeResponseModel instance, MemberInfoModel memberInfoModel) {
        new Thread(() -> this.notifySendMessage(instance, memberInfoModel)).start();
    }

    protected abstract void notifySendMessage(IntegralChangeResponseModel var1, MemberInfoModel var2) throws MemberException;
}

