package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.*;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SyncIntegralVo {

    @NonNull
    private String  brandCode;

    @NonNull
    @ApiModelProperty(value = "线下erpId")
    private String erpId;

    @NonNull
    @ApiModelProperty(value = "流水号唯一")
    private String changeBills;

    @NonNull
    @ApiModelProperty(value = "变更积分 添加为正 扣减为负")
    private Integer changeIntegral;

    @ApiModelProperty(value = "积分来源 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他")
    private String  source;

    private Long sysCompanyId;

    private Long sysBrandId;

    @NonNull
    @ApiModelProperty(value = "线下流水id 唯一")
    private String serialNumber;

    @ApiModelProperty(value = "业务类型")
    private String  businessWay;

    @ApiModelProperty(value = "线上门店code")
    private String onlineStoreCode;

    private String offlineStoreCode;

    @ApiModelProperty(value = "变更详情")
    private String changeDetails;

    @ApiModelProperty(value = "业务类型描述")
    private String businessDescription;
}
