package com.bizvane.members.facade.service.card.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author dingShiChen
 * @since 2019/10/25
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MemberInfoUpdateOtherBrandVO {


	/*
		品牌id
	 */
	@NotNull
	private Long sysBrandId;

	/*
		会员线下id
	 */
	@NotEmpty
	private String erpId;


	/*
		省份证
	 */
	private String idCard;

	/**
	 * 手机号
	 */
	private String phone;

	/**
	 * 会员姓名
	 */
	private String name;

	/**
	 * 会员性别(0是女，1是男，3是未知)
	 */
	private String gender;

	/**
	 * 会员生日 pattern = "yyyyMMdd"
	 */
	private String birthday;

	/**
	 * 省份
	 */
	private String province;

	/**
	 * 城市
	 */
	private String city;

	/**
	 * 区县
	 */
	private String county;

	/**
	 * 详细地址
	 */
	private String address;

	/**
	 * 邮箱
	 */
	private String email;


	/**
	 * 备注
	 */
	private String remark;

	private String serviceStoreCode;

	private String serviceGuideStoreCode;

}
