package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.OrderDetailModel;
import com.bizvane.members.facade.models.OrderPaymentModel;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberOrderDetailApiService {


    @RequestMapping(value = "/api/memberOrderDetail/queryOrderDetail", method = RequestMethod.POST)
    ResponseData<OrderDetailModel>  queryOrderDetail(@RequestBody OrderDetailModel orderDetailModel) throws MemberException;


    @RequestMapping(value = "/api/memberOrderDetail/insert", method = RequestMethod.POST)
    ResponseData insert(@RequestBody List<OrderDetailModel> orderDetailModel) throws MemberException;


    @RequestMapping(value = "/api/memberOrderPay/queryOrderPay", method = RequestMethod.POST)
    ResponseData<OrderPaymentModel>  queryOrderPay(@RequestBody OrderPaymentModel orderPaymentModel) throws MemberException;


    @RequestMapping(value = "/api/memberOrderPay/insert", method = RequestMethod.POST)
    ResponseData insertPayment(@RequestBody List<OrderPaymentModel> orderPaymentModels) throws MemberException;

}
