package com.bizvane.members.facade.service.inner;

import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.models.vo.SysStoreGroupVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionListQueryVO;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/18 11:14
 * @Description:
 */
public interface MemberScreenService {
    /**
     * 查询品牌店铺分页列表
     *
     * @param sysStoreVo
     * @return
     */
    ResponseData<com.github.pagehelper.PageInfo<SysStoreVo>> queryStoreList(SysStoreVo sysStoreVo);

    /**
     * 查询企业下导购员分页列表
     *
     * @param staffVo
     * @return
     */
    ResponseData<PageInfo<StaffVo>> querySalesmanList(StaffVo staffVo);

    /**
     * 查询品牌下店铺分组分页列表
     *
     * @param sysStoreGroupVo
     * @return
     */
    ResponseData<PageInfo<SysStoreGroupVo>> queryGroupStoreList(SysStoreGroupVo sysStoreGroupVo);

    /**
     * 查询品牌下优惠券分页列表
     *
     * @param couponDefinitionListQueryVO
     * @return
     */
    ResponseData<PageInfo<CouponDefinitionPO>> queryCouponList(CouponDefinitionListQueryVO couponDefinitionListQueryVO);

    /**
     * 查询品牌下活动分页列表
     *
     * @param brandId
     * @param pageVo
     * @return
     */
    ResponseData queryActivityList(long brandId, PageVo pageVo);

    /**
     * 查询品牌任务分页列表
     *
     * @param brandId
     * @param pageVo
     * @return
     */
    ResponseData queryTaskList(long brandId, PageVo pageVo);

    /**
     * 查询品牌所有自定义属性
     *
     * @param brandId
     * @return
     */
    ResponseData<List<ExtendPropertyModel>> queryExtendPropertyList(long brandId);

    /**
     * excel导入手机号
     * 2018-09-07 改为卡号
     *
     * @param url
     * @param currentUser
     * @return
     */
    ResponseData<List<String>> importPhoneExcel(String url);

    /**
     * excel导入卡号
     *
     * @param url
     * @return
     */
    ResponseData<List<String>> importCardNoExcel(String url);

    /**
     * excel导入邮箱
     * @param url
     * @return
     */
    ResponseData<List<String>> importEmailExcel(String url);

    /**
     * 查询导入会员的个数
     *
     * @param url
     * @param currentUser
     * @param phoneOrCard 判断url为手机号还是卡号
     * @return
     */
    ResponseData<Long> queryMemberCount(String url, SysAccountPO currentUser, String phoneOrCard);

    /**
     * 查询导入邮箱的个数
     *
     * @param url
     * @param currentUser
     * @param emailType 判断邮箱类型是未验证还是已验证
     * @return
     */
    ResponseData<Long> queryMemberCountByEmail(String url, SysAccountPO currentUser, Integer emailType);
}
