package com.bizvane.members.facade.service.qywxapi;

import java.util.List;
import java.util.Map;

import com.bizvane.members.facade.es.pojo.BasicMembersInfoSearchPojo;
import com.bizvane.members.facade.es.pojo.WxMemberInfoSearchPojo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.members.facade.vo.MembersFriendsWithStoreIdVo;
import com.bizvane.members.facade.vo.MembersInfoRequestVo;
import com.bizvane.members.facade.vo.MembersSearchWithLabelsVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bizvane.members.facade.es.pojo.qywx.MembersFriendPojo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.qywx.MemberFriendsKeyQueryVo;
//import com.bizvane.members.facade.vo.qywx.MemberFriendsKeyQueryVo;
import com.bizvane.members.facade.vo.qywx.MembersFriendVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface WxMembersApiService {

	/**
	 * 更新会员备注
	 * 
	 * @param memberComment
	 * @param memberCode
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/saveAndUpdateMembersComment", method = RequestMethod.POST)
	public ResponseData<Integer> saveAndUpdateMembersComment(@RequestParam("memberComment") String memberComment,
			@RequestParam("memberCode") String memberCode);

	/**
	 * 获取新会员列表
	 * 
	 * @param membersFriendVo
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getMembersList", method = RequestMethod.POST)
	public ResponseData<PageInfo<MembersFriendPojo>> getMembersList(@RequestBody MembersFriendVo membersFriendVo);

	/**
	 * 获取新会员列表排序
	 *
	 * @param membersFriendVo
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getMembersListOrder", method = RequestMethod.POST)
	public ResponseData<PageInfo<MembersFriendPojo>> getMembersListOrder(@RequestBody MembersFriendVo membersFriendVo);


	/**
	 * 查询会员等级
	 * 
	 * @param brandId
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getLevelMap", method = RequestMethod.POST)
	public ResponseData<Map<Long, String>> getLevelMap(@RequestParam("brandId") Long brandId);

	@RequestMapping(value = "/api/wxMembersApi/updateMembersMark", method = RequestMethod.POST)
	public ResponseData<Integer> updateMembersMark(@RequestParam("mark") Integer mark,
			@RequestParam("memberCode") String memberCode);
	
	//根据条件查询会员信息
	@RequestMapping(value = "/api/wxMembersApi/getMemberFriendsWithMultiKeyWord", method = RequestMethod.POST)
	public ResponseData<MemberInfoModel> getMemberFriendsWithMultiKeyWord(
			@RequestBody MemberFriendsKeyQueryVo memberFriendsKeyQueryVo);



	@RequestMapping(value = "/api/wxMembersApi/getMemberCodeByStoreId",method = RequestMethod.POST)
	public ResponseData<List<String>> getMemberCodeByStoreId(@RequestParam("brandId") Long brandId,@RequestParam("companyId") Long companyId,@RequestParam("storeId") Long storeId);


	@RequestMapping(value = "/api/wxMembersApi/getMemberCodeListByStoreIdPageable", method = RequestMethod.POST)
	ResponseData<PageInfo<String>> getMemberCodeListByStoreIdPageable(@RequestBody @Valid MembersFriendsWithStoreIdVo membersFriendsWithStoreIdVo);

	@RequestMapping(value = "/api/wxMembersApi/getMemberCodeListByStoreIdPageV2", method = RequestMethod.POST)
	ResponseData<PageInfo<WxMemberInfoSearchPojo>> getMemberCodeListByStoreIdPageV2(@RequestBody @Valid MembersSearchWithLabelsVo membersSearchWithLabelsVo);

	/**
	 * 获取新会员列表ByNames
	 * @param memberCodes
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getMembersByCodes", method = RequestMethod.POST)
	public ResponseData<List<MemberInfoModel>> getMembersByCodes(@RequestBody @Valid MembersInfoRequestVo memberInfoRequest);

	/**
	 * 根据微信unionId 获取会员信息
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getMembersByUnionId", method = RequestMethod.POST)
	public ResponseData<List<MemberInfoModel>> getMembersByUnionId(@RequestParam("unionId") String unionId);
}
