package com.bizvane.airport.mall.feign.service;

import com.bizvane.airport.mall.feign.model.req.IntegralProductSpecDetailReq;
import com.bizvane.airport.mall.feign.model.res.IntegralProductSpecRes;
import com.bizvane.utils.requestinfo.BasePageReq;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.DeleteValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/productSpec")
@Api("积分商城分类管理")
public interface IntegralMallProductSpecFeign {

    @ApiOperation(value = "新增")
    @PostMapping("/add")
    public ResponseData<Boolean> add(@RequestBody @Validated(CreateValidation.class) IntegralProductSpecDetailReq reqVO);

    @ApiOperation(value = "编辑")
    @PostMapping("/update")
    public ResponseData<Boolean> update(@RequestBody @Validated(UpdateValidation.class) IntegralProductSpecDetailReq reqVO);

    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public ResponseData<Boolean> delete(@RequestBody @Validated(DeleteValidation.class) IntegralProductSpecDetailReq reqVO);

    @ApiOperation(value = "分页")
    @PostMapping("/page")
    public ResponseData<PageInfo<IntegralProductSpecRes>> page(@RequestBody BasePageReq reqVO);

    @ApiOperation(value = "集合")
    @PostMapping("/list")
    public ResponseData<List<IntegralProductSpecRes>> list();

    @ApiOperation(value = "详情")
    @PostMapping("/get")
    public ResponseData<IntegralProductSpecRes> get(@RequestParam("integralProductSpecCode") String integralProductSpecCode);

}

