package com.bizvane.airport.mall.feign.service;

import com.bizvane.airport.mall.feign.model.req.*;
import com.bizvane.airport.mall.feign.model.res.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/logisticInfo")
@Api("积分商城物流信息")
public interface IntegralMallLogisticInfoFeign {

    @ApiOperation(value = "快递详情")
    @PostMapping("/detail")
    public ResponseData<List<LogisticInfoRes>> detail(@RequestBody @Validated LogisticInfoReq reqVO);

}

