package com.bizvane.airport.mall.feign.service;

import com.bizvane.airport.mall.feign.model.req.IntegralConfigReq;
import com.bizvane.airport.mall.feign.model.res.IntegralConfigRes;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/config")
@Api("积分商城分类管理")
public interface IntegralMallConfigFeign {

    @ApiOperation(value = "新增")
    @PostMapping("/add")
    public ResponseData<Boolean> add(@RequestBody @Validated(CreateValidation.class) IntegralConfigReq reqVO);

    @ApiOperation(value = "编辑")
    @PostMapping("/update")
    public ResponseData<Boolean> update(@RequestBody @Validated(UpdateValidation.class) IntegralConfigReq reqVO);

    @ApiOperation(value = "详情")
    @PostMapping("/get")
    public ResponseData<IntegralConfigRes> get();


}

