package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.enumutils.IntegralMallOrderStatusOperationTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class LogisticInfoReq implements Serializable {
    public static final long serialVersionUID = 1L;

    @NotBlank(message = "业务系统code不能为空")
    @ApiModelProperty("业务系统code")
    private String integralMallBusinessCode;

    @NotNull(message = "业务系统类型不能为空, 1.积分商城订单 2.积分商城退单")
    @ApiModelProperty("业务系统类型")
    private Integer integralMallBusinessType;

    @NotBlank(message = "快递公司编码不能为空")
    @ApiModelProperty("快递公司编码")
    private String courierCompanyCode;

    @NotBlank(message = "快递公司名字不能为空")
    @ApiModelProperty("快递公司名字")
    private String courierCompanyName;

    @NotBlank(message = "快递单号不能为空")
    @ApiModelProperty("快递单号")
    private String courierNo;

    @NotBlank(message = "收件人手机号码不能为空")
    @ApiModelProperty("收件人手机号码")
    private String consigneeMobile;

    @ApiModelProperty("操作类型 1.用户操作 2.系统操作 3.后台操作")
    @NotNull(message = "操作类型不能为空")
    private Integer operationType;

    @ApiModelProperty("操作人code")
    private String operationUserCode;

    @ApiModelProperty("操作人姓名")
    private String operationUserName;

    @AssertTrue(message = "操作人信息不能为空")
    public boolean checkOperationUserInfo() {
        return IntegralMallOrderStatusOperationTypeEnum.CENTERSTAGE_OPERATION.getType().equals(operationType) ? StringUtils.isNotBlank(operationUserCode) && StringUtils.isNotBlank(operationUserName) : true;
    }

}
