package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 积分商城退单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城退单")
public class IntegralMallRefundOrderAddReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员系统编号code")
    @NotBlank(message = "会员系统编号code不能为空", groups = {CreateValidation.class})
    private String mbrMemberCode;

    @ApiModelProperty("申请类型 1仅退款")
    @NotNull(message = "申请类型不能为空", groups = {CreateValidation.class})
    private Integer applyType;

    @ApiModelProperty("操作类型 1.用户操作 2.系统操作 3.后台操作")
    @NotNull(message = "操作类型不能为空", groups = {CreateValidation.class})
    private Integer operationType;

    @ApiModelProperty("申请备注")
    private String applyRemark;

    @NotBlank(message = "正单订单系统编号不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("正单订单系统编号 FK")
    private String integralMallOrderCode;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人姓名")
    private String createUserName;
}
