package com.bizvane.fitmentservice.interfaces;

import com.bizvane.fitmentservice.models.vo.AppletBrandPopupFitmentVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author yuantq
 * @date 2022/9/14
 */
public interface AppletBrandPopupFitmentService {

    /**
     * 根据品牌获取最新的一条弹窗装修
     * @param brandId
     * @return
     */
    ResponseData<AppletBrandPopupFitmentVO> getAppletBrandPopupFitment(Long brandId);

    /**
     * 新增或修改弹窗装修信息
     * @param appletBrandPopupFitmentVO
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> saveAppletBrandPopupFitment(AppletBrandPopupFitmentVO appletBrandPopupFitmentVO, SysAccountPO sysAccountPO);

    /**
     * 根据品牌ID获取弹窗装修信息
     * @param brandId
     * @return
     */
    ResponseData<AppletBrandPopupFitmentVO> getPopupFitmentByBrandId(Long brandId);
}
