/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dtm.sdk;

import com.bizvane.dtm.sdk.ApiService;
import com.bizvane.dtm.sdk.CollectOperation;
import com.bizvane.dtm.sdk.CollectOperationImpl;
import com.bizvane.dtm.sdk.DataCollectConfig;
import com.bizvane.dtm.sdk.DataCollectConsumer;
import com.bizvane.dtm.sdk.DateTime;
import com.bizvane.dtm.sdk.EventFileQueueItem;
import com.bizvane.sdk.Config;
import com.bizvane.sdk.Service;
import com.bizvane.sdk.ShutdownHook;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.stimulussoft.filequeue.FileQueue;
import com.stimulussoft.filequeue.processor.Consumer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DataCollectService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(DataCollectService.class);
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private DataCollectConfig config;
    private ShutdownHook shutdownHook;
    private static final String FILE_QUEUE_NAME = "BIZVANE_DTM";
    private FileQueue fileQueue;
    private ApiService apiService;
    private CollectOperationImpl collectOperation;
    private DateTime dateTime;

    @Override
    public synchronized void start() {
        try {
            this.init();
            this.shutdownHook = new ShutdownHook(this);
            this.shutdownHook.setName("DataCollectService");
            this.shutdownHook.setPriority(10);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            OkHttpClient okHttpClient = new OkHttpClient().newBuilder().readTimeout(10000L, TimeUnit.MILLISECONDS).writeTimeout(10000L, TimeUnit.MILLISECONDS).connectTimeout(10000L, TimeUnit.MILLISECONDS).followRedirects(false).build();
            Preconditions.checkNotNull((Object)this.config.getApiServerUrl(), (Object)"apiServerUrl == null");
            Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(this.config.getApiServerUrl()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
            this.apiService = (ApiService)retrofit.create(ApiService.class);
            this.fileQueue = FileQueue.fileQueue();
            Path storePath = Paths.get(this.config.getFileQueueStorePath(), new String[0]);
            FileQueue.Config fileQueueConfig = FileQueue.config((String)FILE_QUEUE_NAME, (Path)storePath, EventFileQueueItem.class, (Consumer)new DataCollectConsumer(this.apiService)).maxQueueSize(20000).retryDelayAlgorithm(FileQueue.RetryDelayAlgorithm.EXPONENTIAL).maxTries(0).persistRetryDelay(20);
            this.fileQueue.startQueue(fileQueueConfig);
            Field shutdownHookField = this.fileQueue.getClass().getDeclaredField("shutdownHook");
            shutdownHookField.setAccessible(true);
            Object o = shutdownHookField.get(this.fileQueue);
            if (o instanceof Thread) {
                Runtime.getRuntime().removeShutdownHook((Thread)o);
            }
            this.collectOperation = new CollectOperationImpl(new DateTime(new Supplier<Long>(){

                public Long get() {
                    Call<Long> call = DataCollectService.this.apiService.getServerTimestamp();
                    Long serverTimestamp = null;
                    try {
                        serverTimestamp = (Long)call.execute().body();
                    }
                    catch (IOException e) {
                        serverTimestamp = System.currentTimeMillis();
                        log.error("\u83b7\u53d6\u670d\u52a1\u5668\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
                    }
                    return serverTimestamp;
                }
            }), Long.parseLong(this.config.getExpireTime()), Long.parseLong(this.config.getMaximumSize()), this.fileQueue);
            this.collectOperation.startSchedule();
            this.isStarted.set(true);
            log.info("\u6570\u636e\u6536\u96c6\u542f\u52a8\u6210\u529f!");
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6536\u96c6\u542f\u52a8\u5931\u8d25!", (Throwable)e);
            System.exit(0);
        }
    }

    public void init() {
        if (this.config == null) {
            this.config = new DataCollectConfig();
        }
    }

    @Override
    public void close() {
        log.info("shutdown hook close");
        if (this.collectOperation != null) {
            this.collectOperation.release();
        }
        if (this.fileQueue != null) {
            this.fileQueue.stopQueue();
        }
        this.isStarted.set(false);
    }

    @Override
    public void config(Config config) {
        if (config == null || !(config instanceof DataCollectConfig)) {
            log.warn("config is null or config type not is DataCollectConfig");
            return;
        }
        this.config = (DataCollectConfig)config;
    }

    @Override
    public CollectOperation getCollectOperation() {
        return this.collectOperation;
    }
}

