/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dtm.sdk;

import com.bizvane.dtm.sdk.CollectOperation;
import com.bizvane.dtm.sdk.DateTime;
import com.bizvane.dtm.sdk.Event;
import com.bizvane.dtm.sdk.EventFileQueueItem;
import com.bizvane.dtm.sdk.EventMessage;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stimulussoft.filequeue.FileQueue;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CollectOperationImpl
implements CollectOperation {
    private static final Logger log = LoggerFactory.getLogger(CollectOperationImpl.class);
    private List<EventMessage> eventMessages = Lists.newCopyOnWriteArrayList();
    private DateTime dateTime;
    private long expireTime = 5000L;
    private long maximumSize = 100L;
    private Function<List<EventMessage>, Boolean> collectFunction;
    private FileQueue fileQueue;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public CollectOperationImpl(DateTime dateTime, FileQueue fileQueue) {
        this.dateTime = dateTime;
        this.fileQueue = fileQueue;
    }

    public CollectOperationImpl(DateTime dateTime, long expireTime, long maximumSize, FileQueue fileQueue) {
        this(dateTime, fileQueue);
        this.expireTime = expireTime;
        this.maximumSize = maximumSize;
    }

    public void startSchedule() {
        this.scheduledExecutorService.scheduleWithFixedDelay(new ReleaseTask(this), 5L, this.expireTime, TimeUnit.MILLISECONDS);
    }

    private synchronized void collect(String endpoint, String eventSerialNumber, String transactionId, Event event, long value) {
        if (endpoint == null) {
            endpoint = "unknown";
        }
        EventMessage em = new EventMessage();
        em.setTimestamp(this.dateTime.getTimeInMillis());
        em.setEndpoint(endpoint);
        em.setEventSerialNumber(eventSerialNumber);
        em.setTransactionId(transactionId);
        em.setValue(value);
        em.setEvent(event);
        this.eventMessages.add(em);
        if ((long)this.eventMessages.size() >= this.maximumSize) {
            this.release();
        }
    }

    @Override
    public void total(String endpoint, String eventSerialNumber, long value) {
        this.collect(endpoint, eventSerialNumber, null, Event.TOTAL, value);
    }

    @Override
    public void increment(String endpoint, String eventSerialNumber, String transactionId, long value) {
        this.collect(endpoint, eventSerialNumber, eventSerialNumber, Event.INCREMENT, value);
    }

    @Override
    public void increment(String endpoint, String eventSerialNumber, long value) {
        this.collect(endpoint, eventSerialNumber, null, Event.INCREMENT, value);
    }

    @Override
    public void increment(String endpoint, String eventSerialNumber) {
        this.collect(endpoint, eventSerialNumber, null, Event.INCREMENT, 1L);
    }

    @Override
    public void decrement(String endpoint, String eventSerialNumber, String transactionId, long value) {
        this.collect(endpoint, eventSerialNumber, eventSerialNumber, Event.DECREMENT, value);
    }

    @Override
    public void decrement(String endpoint, String eventSerialNumber, long value) {
        this.collect(endpoint, eventSerialNumber, null, Event.DECREMENT, value);
    }

    @Override
    public void decrement(String endpoint, String eventSerialNumber) {
        this.collect(endpoint, eventSerialNumber, null, Event.DECREMENT, 1L);
    }

    synchronized void release() {
        if (this.eventMessages.size() > 0) {
            ImmutableList tempEventMessages = ImmutableList.copyOf(this.eventMessages);
            EventFileQueueItem queueItem = new EventFileQueueItem();
            queueItem.setEventMessages((List<EventMessage>)tempEventMessages);
            try {
                this.fileQueue.queueItem((Object)queueItem);
                this.eventMessages.clear();
            }
            catch (IOException e) {
                log.error("\u5199\u5165\u6587\u4ef6\u961f\u5217\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public List<EventMessage> getEventMessages() {
        return this.eventMessages;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public Function<List<EventMessage>, Boolean> getCollectFunction() {
        return this.collectFunction;
    }

    public FileQueue getFileQueue() {
        return this.fileQueue;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setEventMessages(List<EventMessage> eventMessages) {
        this.eventMessages = eventMessages;
    }

    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public void setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setCollectFunction(Function<List<EventMessage>, Boolean> collectFunction) {
        this.collectFunction = collectFunction;
    }

    public void setFileQueue(FileQueue fileQueue) {
        this.fileQueue = fileQueue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectOperationImpl)) {
            return false;
        }
        CollectOperationImpl other = (CollectOperationImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<EventMessage> this$eventMessages = this.getEventMessages();
        List<EventMessage> other$eventMessages = other.getEventMessages();
        if (this$eventMessages == null ? other$eventMessages != null : !((Object)this$eventMessages).equals(other$eventMessages)) {
            return false;
        }
        DateTime this$dateTime = this.getDateTime();
        DateTime other$dateTime = other.getDateTime();
        if (this$dateTime == null ? other$dateTime != null : !this$dateTime.equals(other$dateTime)) {
            return false;
        }
        if (this.getExpireTime() != other.getExpireTime()) {
            return false;
        }
        if (this.getMaximumSize() != other.getMaximumSize()) {
            return false;
        }
        Function<List<EventMessage>, Boolean> this$collectFunction = this.getCollectFunction();
        Function<List<EventMessage>, Boolean> other$collectFunction = other.getCollectFunction();
        if (this$collectFunction == null ? other$collectFunction != null : !this$collectFunction.equals(other$collectFunction)) {
            return false;
        }
        FileQueue this$fileQueue = this.getFileQueue();
        FileQueue other$fileQueue = other.getFileQueue();
        if (this$fileQueue == null ? other$fileQueue != null : !this$fileQueue.equals(other$fileQueue)) {
            return false;
        }
        ScheduledExecutorService this$scheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService other$scheduledExecutorService = other.getScheduledExecutorService();
        return !(this$scheduledExecutorService == null ? other$scheduledExecutorService != null : !this$scheduledExecutorService.equals(other$scheduledExecutorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectOperationImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EventMessage> $eventMessages = this.getEventMessages();
        result = result * 59 + ($eventMessages == null ? 43 : ((Object)$eventMessages).hashCode());
        DateTime $dateTime = this.getDateTime();
        result = result * 59 + ($dateTime == null ? 43 : $dateTime.hashCode());
        long $expireTime = this.getExpireTime();
        result = result * 59 + (int)($expireTime >>> 32 ^ $expireTime);
        long $maximumSize = this.getMaximumSize();
        result = result * 59 + (int)($maximumSize >>> 32 ^ $maximumSize);
        Function<List<EventMessage>, Boolean> $collectFunction = this.getCollectFunction();
        result = result * 59 + ($collectFunction == null ? 43 : $collectFunction.hashCode());
        FileQueue $fileQueue = this.getFileQueue();
        result = result * 59 + ($fileQueue == null ? 43 : $fileQueue.hashCode());
        ScheduledExecutorService $scheduledExecutorService = this.getScheduledExecutorService();
        result = result * 59 + ($scheduledExecutorService == null ? 43 : $scheduledExecutorService.hashCode());
        return result;
    }

    public String toString() {
        return "CollectOperationImpl(eventMessages=" + this.getEventMessages() + ", dateTime=" + this.getDateTime() + ", expireTime=" + this.getExpireTime() + ", maximumSize=" + this.getMaximumSize() + ", collectFunction=" + this.getCollectFunction() + ", fileQueue=" + this.getFileQueue() + ", scheduledExecutorService=" + this.getScheduledExecutorService() + ")";
    }

    class ReleaseTask
    implements Runnable {
        private CollectOperationImpl collectOperation;

        public ReleaseTask(CollectOperationImpl collectOperation) {
            this.collectOperation = collectOperation;
        }

        @Override
        public void run() {
            if (this.collectOperation != null) {
                this.collectOperation.release();
            }
        }
    }
}

